require( "HiddenObject/script/style.lua" );

OkGraphics = {
	"HiddenObject/UI/Button/oknormal.png",
	"HiddenObject/UI/Button/okdown.png",
	"HiddenObject/UI/Button/okover.png",
};	

OkStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = ButtonFont,
	graphics = OkGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};



BodyFont = {
  standardFont,
  20,
  WhiteColor
};



HeaderFont = {
  standardFont,
  24,
  WhiteColor
};




function GetWindowX()

	x = kCenter;
	if IsMainMenu() then x = 342; end
	return x;
end



function GetWindowY()

	y = kCenter - 45;
	if IsMainMenu() then y = 160; end
	return y;
end

MakeDialog
{
	name = "okDialog";
    Bitmap
    {
        name="yesnobackground",
		image="HiddenObject/UI/background/smalldialog",
		x=GetWindowX(),
		y=GetWindowY(),
        
        SetStyle(OkStyle),
        Button
        {
			font = StandardButtonFont,
            close = true,
            flags = 5,
            label = "ok",
            name = "ok",
            x = kCenter,
            y = -80,
        },
        
        SetStyle(DefaultStyle),
        Text
		{
			font = HeaderFont,
			name = "oktitle",
			x=kCenter, y=20,
			w=kMax,h=40,
			flags = kVAlignCenter + kHAlignCenter,
			label= gDialogTable.title,
		};
		
		Text
		{
			font = BodyFont,
			name = "okbody",
			x=kCenter,y=60,
			w=kMax,h=kMax-70,
			flags = kVAlignCenter + kHAlignCenter,
			label= gDialogTable.body,
		};
    },

} -- MakeDialog
